
import gurobipy as gp

def solve_jelly_pouch_problem():
    # Create a new model
    model = gp.Model("jelly_pouch_problem")

    # Define variables
    x1 = model.addVar(name="blue_jelly_pouches", lb=0, vtype=gp.GRB.INTEGER)
    x2 = model.addVar(name="red_jelly_pouches", lb=0, vtype=gp.GRB.INTEGER)

    # Define objective function
    model.setObjective(5 * x1 + 7 * x2, gp.GRB.MINIMIZE)

    # Define constraints
    model.addConstr(2 * x1 + 3 * x2 >= 30, name="calcium_requirement")
    model.addConstr(x1 + 2 * x2 >= 25, name="potassium_requirement")
    model.addConstr(3 * x1 + x2 >= 30, name="sodium_requirement")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution: blue jelly pouches = {x1.varValue}, red jelly pouches = {x2.varValue}")
        print(f"Minimum cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_jelly_pouch_problem()
