
import gurobipy as gp

# Create a new model
m = gp.Model("Gabriel's Diet")

# Create variables
lemons = m.addVar(lb=0, name="lemons")  # Pounds of lemons
pecans = m.addVar(lb=0, name="pecans")  # Pounds of pecans

# Set objective function: Minimize cost
m.setObjective(12 * lemons + 10 * pecans, gp.GRB.MINIMIZE)

# Add constraints:
m.addConstr(3 * lemons + 5 * pecans >= 25, "Calcium")  # Calcium requirement
m.addConstr(4 * lemons + 4 * pecans >= 18, "Potassium") # Potassium requirement
m.addConstr(7 * lemons + 9 * pecans >= 19, "Zinc")  # Zinc requirement


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Pounds of lemons: {lemons.x:.2f}")
    print(f"Pounds of pecans: {pecans.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

