
from gurobipy import *

# Create a new model
m = Model("Gabriel_Nutrition")

# Define variables
x1 = m.addVar(name="lemons", lb=0)
x2 = m.addVar(name="pecans", lb=0)

# Set the objective function
m.setObjective(12*x1 + 10*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1 + 5*x2 >= 25, name="calcium")
m.addConstr(4*x1 + 4*x2 >= 18, name="potassium")
m.addConstr(7*x1 + 9*x2 >= 19, name="zinc")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Lemons: {x1.x}")
    print(f"Pecans: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
