
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="lemons", lb=0)  # Pounds of lemons
    x2 = model.addVar(name="pecans", lb=0)  # Pounds of pecans

    # Objective function: minimize cost
    model.setObjective(12 * x1 + 10 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3 * x1 + 5 * x2 >= 25, name="calcium_requirement")
    model.addConstr(4 * x1 + 4 * x2 >= 18, name="potassium_requirement")
    model.addConstr(7 * x1 + 9 * x2 >= 19, name="zinc_requirement")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Pounds of lemons: {x1.varValue}")
        print(f"Pounds of pecans: {x2.varValue}")
        print(f"Total cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
