
from gurobipy import Model, GRB

# Create a new model
m = Model("hockey_arena")

# Create variables
heated_seats = m.addVar(vtype=GRB.INTEGER, name="heated_seats")
regular_seats = m.addVar(vtype=GRB.INTEGER, name="regular_seats")

# Set objective function
m.setObjective(30 * heated_seats + 20 * regular_seats, GRB.MAXIMIZE)

# Add constraints
m.addConstr(heated_seats + regular_seats <= 300, "capacity")
m.addConstr(heated_seats >= 50, "min_heated")
m.addConstr(regular_seats >= 3 * heated_seats, "regular_preference")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Maximum profit: ${m.objVal}")
    print(f"Number of heated seats: {heated_seats.x}")
    print(f"Number of regular seats: {regular_seats.x}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status {m.status}")

