
from gurobipy import *

# Create a new model
m = Model("Hockey_Arena_Profit")

# Define variables
x1 = m.addVar(name='heated_seats', vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name='regular_seats', vtype=GRB.INTEGER, lb=0)

# Set the objective function
m.setObjective(30*x1 + 20*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 300, name='total_capacity')
m.addConstr(x1 >= 50, name='min_heated_seats')
m.addConstr(x2 >= 3*x1, name='regular_vs_heated')

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Heated seats sold: {x1.x}")
    print(f"Regular seats sold: {x2.x}")
    print(f"Maximum profit: ${30*x1.x + 20*x2.x}")
else:
    print("No optimal solution found")
