
import gurobi as gp

# Define the model
m = gp.Model("Hockey_Arena_Seating")

# Define the variables
x1 = m.addVar(name="heated_seats", lb=0, vtype=gp.GRB.INTEGER)  # Heated seats
x2 = m.addVar(name="regular_seats", lb=0, vtype=gp.GRB.INTEGER)  # Regular seats

# Objective function: Maximize profit
m.setObjective(30*x1 + 20*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 + x2 <= 300, name="total_seats")  # Total seats constraint
m.addConstr(x1 >= 50, name="min_heated_seats")  # Minimum heated seats constraint
m.addConstr(x2 >= 3*x1, name="regular_seats_preference")  # Preference for regular seats

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: Heated seats = {x1.varValue}, Regular seats = {x2.varValue}")
    print(f"Maximum profit: ${30*x1.varValue + 20*x2.varValue}")
else:
    print("No optimal solution found")
