
from gurobipy import Model, GRB

# Create a new model
m = Model("grape_optimization")

# Create variables
red_grapes = m.addVar(name="red_grapes")
green_grapes = m.addVar(name="green_grapes")

# Set objective function
m.setObjective(300 * red_grapes + 250 * green_grapes, GRB.MAXIMIZE)

# Add constraints
m.addConstr(red_grapes + green_grapes <= 100, "total_acres")
m.addConstr(red_grapes >= 30, "min_red")
m.addConstr(green_grapes >= 25, "min_green")
m.addConstr(green_grapes <= 2 * red_grapes, "green_limit")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Acres of red grapes: {red_grapes.x:.2f}")
    print(f"Acres of green grapes: {green_grapes.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

