
from gurobipy import *

# Create a new model
m = Model("Vine_Farmer_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="red_grapes")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="green_grapes")

# Set the objective function
m.setObjective(300*x1 + 250*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 100, "total_acres")
m.addConstr(x1 >= 30, "min_red_grapes")
m.addConstr(x2 >= 25, "min_green_grapes")
m.addConstr(x2 <= 2*x1, "max_green_to_red_ratio")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
