
import gurobi

def solve_vine_farmer_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="red_grapes")  # acres of red grapes
    x2 = model.addVar(lb=0, name="green_grapes")  # acres of green grapes

    # Objective function: maximize profit
    model.setObjective(300*x1 + 250*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 100, name="total_land")
    model.addConstr(x1 >= 30, name="min_red_grapes")
    model.addConstr(x2 >= 25, name="min_green_grapes")
    model.addConstr(x2 <= 2*x1, name="green_vs_red_ratio")

    # Update model
    model.update()

    # Solve model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of red grapes: {x1.varValue}")
        print(f"Optimal acres of green grapes: {x2.varValue}")
        print(f"Max profit: ${300*x1.varValue + 250*x2.varValue}")
    else:
        print("The problem is infeasible")

solve_vine_farmer_problem()
