
import gurobipy as gp

# Create a new model
model = gp.Model("CreamMixture")

# Create decision variables
alpha = model.addVar(lb=0, name="alpha")  # Cream Alpha (mg)
beta = model.addVar(lb=0, name="beta")   # Cream Beta (mg)

# Set objective function: Minimize cost
model.setObjective(0.7 * alpha + 0.9 * beta, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(2 * alpha + 4.1 * beta >= 4, "Compound_X")
model.addConstr(2.7 * alpha + 3.2 * beta >= 8, "Compound_Y")


# Optimize the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Cost: ${model.objVal:.2f}")
    print(f"Cream Alpha: {alpha.x:.2f} mg")
    print(f"Cream Beta: {beta.x:.2f} mg")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

