
from gurobipy import *

# Create a new model
m = Model("Kappa_Medical_Cream_Mixture")

# Define the variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="cream_alpha", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="cream_beta", lb=0)

# Set the objective function
m.setObjective(0.70*x1 + 0.90*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + 4.1*x2 >= 4, name="compound_x_constraint")
m.addConstr(2.7*x1 + 3.2*x2 >= 8, name="compound_y_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Amount of cream Alpha: {x1.x} mg")
    print(f"Amount of cream Beta: {x2.x} mg")
    print(f"Total cost: ${m.objVal:.2f}")
else:
    print("No optimal solution found.")
