
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="x2", lb=0, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(0.70 * x1 + 0.90 * x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(2 * x1 + 4.1 * x2 >= 4, name="compound_X")
    model.addConstr(2.7 * x1 + 3.2 * x2 >= 8, name="compound_Y")

    # Optimize the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Amount of cream Alpha: {x1.varValue} mg")
        print(f"Amount of cream Beta: {x2.varValue} mg")
        print(f"Minimum cost: ${model.objVal:.2f}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

solve_optimization_problem()
