
import gurobipy as gp

# Create a new model
model = gp.Model("Candy Mixture Optimization")

# Create decision variables
x1 = model.addVar(lb=0, name="mixture_A")  # Kilograms of mixture A
x2 = model.addVar(lb=0, name="mixture_B")  # Kilograms of mixture B

# Set objective function
model.setObjective(30 * x1 + 40 * x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(0.75 * x1 + 0.40 * x2 <= 30, "gummy_bears_constraint")
model.addConstr(0.25 * x1 + 0.60 * x2 <= 25, "gummy_worms_constraint")


# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Kilograms of Mixture A: {x1.x}")
    print(f"Kilograms of Mixture B: {x2.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

