
from gurobipy import *

# Create a model
m = Model("Candy_Mixtures")

# Define variables
x1 = m.addVar(name="Mixture_A", lb=0)
x2 = m.addVar(name="Mixture_B", lb=0)

# Set the objective function
m.setObjective(30*x1 + 40*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.75*x1 + 0.40*x2 <= 30, name="Gummy_Bears")
m.addConstr(0.25*x1 + 0.60*x2 <= 25, name="Gummy_Worms")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Mixture A: {x1.x} kg")
    print(f"Mixture B: {x2.x} kg")
    print(f"Total Profit: ${30*x1.x + 40*x2.x}")
else:
    print("No optimal solution found")

