
import gurobi

def solve_mixture_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0, ub=gurobi.GRB.INFINITY, obj=30)
    x2 = model.addVar(name="x2", lb=0, ub=gurobi.GRB.INFINITY, obj=40)

    # Add constraints
    model.addConstr(x1 * 0.75 + x2 * 0.40 <= 30, name="gummy_bears")
    model.addConstr(x1 * 0.25 + x2 * 0.60 <= 25, name="gummy_worms")

    # Set the model objective to maximize
    model.setObjective(x1.obj * x1.var, gurobi.GRB.MAXIMIZE)

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution:")
        print(f"Mixture A: {x1.x:.2f} kg")
        print(f"Mixture B: {x2.x:.2f} kg")
        print(f"Max Profit: {model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_mixture_problem()
