
import gurobipy as gp

# Create a new model
m = gp.Model("supplement_optimization")

# Create variables
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="servings_of_supplement_A")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="servings_of_supplement_B")


# Set objective function
m.setObjective(2*x1 + 4*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 + 4*x2 >= 12, "keratin_requirement")
m.addConstr(5*x1 + x2 >= 20, "calcium_requirement")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Objective value: {m.objVal}")
    print(f"Servings of supplement A: {x1.x}")
    print(f"Servings of supplement B: {x2.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

