
from gurobipy import *

# Create a new model
m = Model("Supplement_Optimization")

# Define variables
x1 = m.addVar(name='x1', lb=0)  # Servings of supplement A
x2 = m.addVar(name='x2', lb=0)  # Servings of supplement B

# Set the objective function
m.setObjective(2*x1 + 4*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 + 4*x2 >= 12, name='keratin_requirement')
m.addConstr(5*x1 + x2 >= 20, name='calcium_requirement')

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Servings of supplement A: {x1.x}")
    print(f"Servings of supplement B: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
