
import gurobi

def solve_supplement_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0, vtype=gurobi.GRB.CONTINUOUS)  # servings of supplement A
    x2 = model.addVar(name="x2", lb=0, vtype=gurobi.GRB.CONTINUOUS)  # servings of supplement B

    # Define the objective function
    model.setObjective(2*x1 + 4*x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(x1 + 4*x2 >= 12, name="keratin_requirement")
    model.addConstr(5*x1 + x2 >= 20, name="calcium_requirement")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Servings of supplement A: {x1.varValue}")
        print(f"Servings of supplement B: {x2.varValue}")
        print(f"Total cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_supplement_problem()
