
import gurobipy as gp

# Create a new model
m = gp.Model("warehouse_optimization")

# Create variables
rafts = m.addVar(vtype=gp.GRB.CONTINUOUS, name="rafts")
kayaks = m.addVar(vtype=gp.GRB.CONTINUOUS, name="kayaks")


# Set objective function
m.setObjective(45 * rafts + 55 * kayaks, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * rafts + 12 * kayaks <= 400, "space_constraint")
m.addConstr(200 * rafts + 250 * kayaks <= 10000, "budget_constraint")
m.addConstr(rafts >= 0.55 * (rafts + kayaks), "raft_proportion_constraint")
m.addConstr(rafts >= 0, "rafts_nonnegative")
m.addConstr(kayaks >= 0, "kayaks_nonnegative")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: {m.objVal}")
    print(f"Number of rafts: {rafts.x}")
    print(f"Number of kayaks: {kayaks.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

