
from gurobipy import *

# Create a new model
m = Model("Sports_Warehouse")

# Define variables
x1 = m.addVar(name='rafts', vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name='kayaks', vtype=GRB.INTEGER, lb=0)

# Set the objective function
m.setObjective(45*x1 + 55*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 12*x2 <= 400, name='space_constraint')
m.addConstr(200*x1 + 250*x2 <= 10000, name='budget_constraint')

# Percentage constraint requires a bit of manipulation to avoid division by zero and non-linear terms
# We can rearrange the percentage constraint as follows: x1 >= 0.55*(x1 + x2)
# Simplifying, we get: 0.45*x1 >= 0.55*x2
# Which further simplifies to: 9*x1 >= 11*x2 (after multiplying both sides by 20 to eliminate decimals)
m.addConstr(9*x1 >= 11*x2, name='percentage_constraint')

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Rafts: {x1.x}")
    print(f"Kayaks: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
