
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="rafts", lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="kayaks", lb=0, vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(45 * x1 + 55 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(10 * x1 + 12 * x2 <= 400, name="space_constraint")
    model.addConstr(200 * x1 + 250 * x2 <= 10000, name="budget_constraint")
    model.addConstr(0.45 * x1 - 0.55 * x2 >= 0, name="raft_percentage_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of rafts: {x1.varValue}")
        print(f"Number of kayaks: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
