
import gurobipy as gp

# Create a new model
model = gp.Model("BakeryOptimization")

# Create variables
donuts = model.addVar(vtype=gp.GRB.CONTINUOUS, name="donuts")
pastries = model.addVar(vtype=gp.GRB.CONTINUOUS, name="pastries")


# Set objective function
model.setObjective(2 * donuts + 4 * pastries, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2 * donuts + 5 * pastries <= 10000, "baking_constraint")
model.addConstr(3 * donuts + 2 * pastries <= 7000, "stuffing_constraint")
model.addConstr(donuts >= 0, "donuts_nonnegative")
model.addConstr(pastries >= 0, "pastries_nonnegative")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal}")
    print(f"Number of donuts: {donuts.x}")
    print(f"Number of pastries: {pastries.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

