
from gurobipy import *

# Create a new model
m = Model("Bakery_Optimization")

# Define the variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="stuffed_donuts")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="stuffed_pastries")

# Set the objective function
m.setObjective(2*x1 + 4*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + 5*x2 <= 10000, "baking_machine")
m.addConstr(3*x1 + 2*x2 <= 7000, "stuffing_machine")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of stuffed donuts: {x1.x}")
    print(f"Number of stuffed pastries: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
