
import gurobipy as gp

def solve_bakery_problem():
    # Create a new model
    model = gp.Model("bakery_problem")

    # Define variables
    x1 = model.addVar(name="donuts", lb=0, vtype=gp.GRB.CONTINUOUS)
    x2 = model.addVar(name="pastries", lb=0, vtype=gp.GRB.CONTINUOUS)

    # Objective function: Maximize 2*x1 + 4*x2
    model.setObjective(2*x1 + 4*x2, gp.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2*x1 + 5*x2 <= 10000, name="baking_machine_constraint")
    model.addConstr(3*x1 + 2*x2 <= 7000, name="stuffing_machine_constraint")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_bakery_problem()
