
import gurobipy as gp

# Create a new model
m = gp.Model("grocery_optimization")

# Create variables
nuts = m.addVar(vtype=gp.GRB.CONTINUOUS, name="nuts")  # Containers of nuts
candy = m.addVar(vtype=gp.GRB.CONTINUOUS, name="candy") # Containers of candy

# Set objective function
m.setObjective(5 * nuts + 3 * candy, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * nuts + 5 * candy <= 1000, "weighing_time")
m.addConstr(5 * nuts + 8 * candy <= 1500, "packaging_time")
m.addConstr(nuts >= 0, "nuts_nonnegative")
m.addConstr(candy >= 0, "candy_nonnegative")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Containers of nuts: {nuts.x:.2f}")
    print(f"Containers of candy: {candy.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

