
from gurobipy import *

# Create a new model
m = Model("Grocery_Optimization")

# Define variables
x1 = m.addVar(name="nuts", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="candy", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(5*x1 + 3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 5*x2 <= 1000, name="weighing_time")
m.addConstr(5*x1 + 8*x2 <= 1500, name="packaging_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of containers of nuts: {x1.x}")
    print(f"Number of containers of candy: {x2.x}")
    print(f"Maximum profit: ${5*x1.x + 3*x2.x:.2f}")
else:
    print("No optimal solution found")
