
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="nuts")
    x2 = model.addVar(lb=0, name="candy")

    # Define the objective function
    model.setObjective(5 * x1 + 3 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(10 * x1 + 5 * x2 <= 1000, name="weighing_constraint")
    model.addConstr(5 * x1 + 8 * x2 <= 1500, name="packaging_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Containers of nuts: {x1.varValue}")
        print(f"Containers of candy: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
