
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
carrots = m.addVar(lb=0, name="carrots")  # Cups of carrots
spinach = m.addVar(lb=0, name="spinach")  # Cups of spinach

# Set objective function: Minimize cost
m.setObjective(5 * carrots + 3 * spinach, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(1 * carrots + 2 * spinach >= 20, "biotin_req")  # Biotin requirement
m.addConstr(3 * carrots + 1.5 * spinach >= 20, "folate_req")  # Folate requirement


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Cups of carrots: {carrots.x}")
    print(f"  Cups of spinach: {spinach.x}")
    print(f"  Minimum cost: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

