
from gurobipy import *

# Create a model
m = Model("Optimal_Diet")

# Define the variables
x1 = m.addVar(lb=0, name="cups_of_carrots")
x2 = m.addVar(lb=0, name="cups_of_spinach")

# Set the objective function
m.setObjective(5*x1 + 3*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 + 2*x2 >= 20, "biotin_requirement")
m.addConstr(3*x1 + 1.5*x2 >= 20, "folate_requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cups of carrots: {x1.x}")
    print(f"Cups of spinach: {x2.x}")
    print(f"Total cost: ${5*x1.x + 3*x2.x:.2f}")
else:
    print("No optimal solution found")
