
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(lb=0, name="cups_of_carrots")
x2 = model.addVar(lb=0, name="cups_of_spinach")

# Set the objective function
model.setObjective(5 * x1 + 3 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(x1 + 2 * x2 >= 20, name="biotin_requirement")
model.addConstr(3 * x1 + 1.5 * x2 >= 20, name="folate_requirement")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Cups of carrots: {x1.varValue}")
    print(f"Cups of spinach: {x2.varValue}")
    print(f"Total cost: ${5 * x1.varValue + 3 * x2.varValue:.2f}")
else:
    print("No optimal solution found.")
