
import gurobipy as gp

# Create a new model
model = gp.Model("sandwich_optimization")

# Create variables
x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="meatball_sandwiches")  # Number of meatball sandwiches
x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="ham_sandwiches")  # Number of ham sandwiches


# Set objective function
model.setObjective(3 * x1 + 3.5 * x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(25 * x1 + 30 * x2 <= 4000, "meat_constraint")
model.addConstr(10 * x1 + 25 * x2 <= 5000, "cheese_constraint")
model.addConstr(50 * x1 + 20 * x2 <= 5200, "sauce_constraint")
model.addConstr(x1 >= 0)
model.addConstr(x2 >= 0)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of meatball sandwiches: {x1.x}")
    print(f"Number of ham sandwiches: {x2.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

