
import gurobipy as gp

# Create a new model
m = gp.Model("Sandwich_Optimization")

# Define variables
x1 = m.addVar(name="meatball_sandwiches", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = m.addVar(name="ham_sandwiches", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function
m.setObjective(3*x1 + 3.50*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(25*x1 + 30*x2 <= 4000, name="meat_constraint")
m.addConstr(10*x1 + 25*x2 <= 5000, name="cheese_constraint")
m.addConstr(50*x1 + 20*x2 <= 5200, name="sauce_constraint")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Meatball Sandwiches: {x1.varValue}")
    print(f"Ham Sandwiches: {x2.varValue}")
    print(f"Max Profit: {m.objVal}")
else:
    print("The model is infeasible or has no optimal solution.")
