
import gurobipy as gp

# Create a new model
m = gp.Model("hot_sauce_optimization")

# Create variables
large_bottles = m.addVar(vtype=gp.GRB.CONTINUOUS, name="large_bottles")
small_bottles = m.addVar(vtype=gp.GRB.CONTINUOUS, name="small_bottles")

# Set objective function
m.setObjective(5 * large_bottles + 3 * small_bottles, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * large_bottles + 2 * small_bottles <= 1000, "budget_constraint")
m.addConstr(2 * large_bottles + small_bottles <= 500, "shelf_space_constraint")
m.addConstr(small_bottles >= 0.5 * (large_bottles + small_bottles), "small_bottle_proportion_constraint")
m.addConstr(large_bottles >= 0, "non_negativity_large")
m.addConstr(small_bottles >= 0, "non_negativity_small")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: {m.objVal}")
    print(f"Number of large bottles: {large_bottles.x}")
    print(f"Number of small bottles: {small_bottles.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

