
from gurobipy import *

# Create a model
m = Model("Hot_Sauce_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="large_bottles")
x2 = m.addVar(vtype=GRB.INTEGER, name="small_bottles")

# Set objective function
m.setObjective(5*x1 + 3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 2*x2 <= 1000, "budget")
m.addConstr(2*x1 + x2 <= 500, "shelf_space")
m.addConstr(x2 >= x1, "small_bottles_percentage")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Large bottles = {x1.x}, Small bottles = {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
