
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="large_bottles", lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="small_bottles", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize 5*x1 + 3*x2
    model.setObjective(5*x1 + 3*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3*x1 + 2*x2 <= 1000, name="budget_constraint")
    model.addConstr(2*x1 + x2 <= 500, name="shelf_space_constraint")
    model.addConstr(x1 - x2 <= 0, name="small_bottles_proportion_constraint")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: large bottles = {x1.varValue}, small bottles = {x2.varValue}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
