
import gurobipy as gp

# Create a new model
model = gp.Model("Advertising Optimization")

# Create variables
search_ads = model.addVar(vtype=gp.GRB.INTEGER, name="search_ads")
video_ads = model.addVar(vtype=gp.GRB.INTEGER, name="video_ads")
social_ads = model.addVar(vtype=gp.GRB.INTEGER, name="social_ads")

# Set objective function
model.setObjective(100000 * search_ads + 7000 * video_ads + 800 * social_ads, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(50000 * search_ads + 5000 * video_ads + 1000 * social_ads <= 850000, "budget_constraint")
model.addConstr(video_ads <= 4, "video_ads_limit")
model.addConstr(social_ads <= 0.5 * (search_ads + video_ads + social_ads), "social_ads_proportion")
model.addConstr(search_ads >= 0.1 * (search_ads + video_ads + social_ads), "search_ads_proportion")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Influence: {model.objVal}")
    print(f"Number of Search Engine Ads: {search_ads.x}")
    print(f"Number of Video Ads: {video_ads.x}")
    print(f"Number of Social Media Ads: {social_ads.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

