
import gurobipy as gp

# Create a new model
m = gp.Model("advertisements")

# Define variables
x1 = m.addVar(name="search_engine_advertisements", vtype=gp.GRB.INTEGER, lb=0)
x2 = m.addVar(name="video_advertisements", vtype=gp.GRB.INTEGER, lb=0)
x3 = m.addVar(name="social_media_advertisements", vtype=gp.GRB.INTEGER, lb=0)

# Objective function: maximize influence
m.setObjective(100000*x1 + 7000*x2 + 800*x3, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(50000*x1 + 5000*x2 + 1000*x3 <= 850000, name="budget_constraint")
m.addConstr(x2 <= 4, name="video_limit_constraint")
m.addConstr(x3 <= 0.5*(x1 + x2 + x3), name="social_media_limit_constraint")
m.addConstr(x1 >= 0.1*(x1 + x2 + x3), name="search_engine_requirement_constraint")

# Solve the model
m.solve()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Search Engine Advertisements: {x1.varValue}")
    print(f"Video Advertisements: {x2.varValue}")
    print(f"Social Media Advertisements: {x3.varValue}")
    print(f"Max Influence: {m.objVal}")
else:
    print("No optimal solution found.")
