
import gurobipy as gp

# Create a new model
model = gp.Model("Chocolate Mixture")

# Create variables
milk_chocolate = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milk_chocolate")
dark_chocolate = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dark_chocolate")


# Set objective function
model.setObjective(0.5 * milk_chocolate + 0.75 * dark_chocolate, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(3 * milk_chocolate + 4 * dark_chocolate >= 120, "cacao_constraint")
model.addConstr(2 * milk_chocolate + 1 * dark_chocolate >= 80, "sugar_constraint")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print(f"Optimal Cost: ${model.objVal:.2f}")
    print(f"Milk Chocolate Pieces: {milk_chocolate.x:.2f}")
    print(f"Dark Chocolate Pieces: {dark_chocolate.x:.2f}")

