
from gurobipy import *

# Create a new model
model = Model("Chocolate_Mixture")

# Add variables
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="milk_chocolate_pieces", lb=0)
x2 = model.addVar(vtype=GRB.CONTINUOUS, name="dark_chocolate_pieces", lb=0)

# Set the objective function
model.setObjective(0.50*x1 + 0.75*x2, GRB.MINIMIZE)

# Add constraints
model.addConstr(3*x1 + 4*x2 >= 120, "cacao_constraint")
model.addConstr(2*x1 + x2 >= 80, "sugar_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of milk chocolate pieces: {x1.x}")
    print(f"Number of dark chocolate pieces: {x2.x}")
    print(f"Total cost: {model.objVal}")
else:
    print("No optimal solution found")
