
import gurobi

def solve_baker_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milk_chocolate", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="dark_chocolate", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(0.50 * x1 + 0.75 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(3 * x1 + 4 * x2 >= 120, name="cacao_constraint")
    model.addConstr(2 * x1 + x2 >= 80, name="sugar_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of milk chocolate pieces: {x1.varValue}")
        print(f"Number of dark chocolate pieces: {x2.varValue}")
        print(f"Total cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_baker_problem()
