
import gurobipy as gp

# Create a new model
m = gp.Model("Sports_Company_Production")

# Create variables
shuttlecocks = m.addVar(vtype=gp.GRB.CONTINUOUS, name="shuttlecocks")
volleyballs = m.addVar(vtype=gp.GRB.CONTINUOUS, name="volleyballs")


# Set objective function
m.setObjective(3.5 * shuttlecocks + 10 * volleyballs, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(15 * shuttlecocks + 20 * volleyballs <= 4000, "sewing_time")
m.addConstr(5 * shuttlecocks + 10 * volleyballs <= 3000, "quality_check_time")
m.addConstr(shuttlecocks >= 0, "shuttlecocks_nonnegative")  # Ensure non-negative production
m.addConstr(volleyballs >= 0, "volleyballs_nonnegative") # Ensure non-negative production


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of shuttlecocks to produce: {shuttlecocks.x}")
    print(f"Number of volleyballs to produce: {volleyballs.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

