
from gurobipy import *

# Create a new model
m = Model("Sports_Company_Optimization")

# Define variables
x1 = m.addVar(name="shuttlecocks", lb=0)
x2 = m.addVar(name="volleyballs", lb=0)

# Set the objective function
m.setObjective(3.5*x1 + 10*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x1 + 20*x2 <= 4000, name="sewing_time")
m.addConstr(5*x1 + 10*x2 <= 3000, name="quality_checking_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of shuttlecocks: {x1.x}")
    print(f"Number of volleyballs: {x2.x}")
    print(f"Maximum profit: ${3.5*x1.x + 10*x2.x:.2f}")
else:
    print("No optimal solution found")
