
import gurobipy as gp

# Create a new model
model = gp.Model("Shuttlecocks_Volleyballs")

# Define the variables
x1 = model.addVar(name="shuttlecocks", lb=0)
x2 = model.addVar(name="volleyballs", lb=0)

# Define the objective function
model.setObjective(3.5 * x1 + 10 * x2, gp.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(15 * x1 + 20 * x2 <= 4000, name="sewing_time")
model.addConstr(5 * x1 + 10 * x2 <= 3000, name="quality_checking_time")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of shuttlecocks: {x1.varValue}")
    print(f"Number of volleyballs: {x2.varValue}")
    print(f"Max profit: {model.objVal}")
else:
    print("No optimal solution found.")
