
import gurobipy as gp

# Create a new model
m = gp.Model("glass_animals")

# Create variables
dogs = m.addVar(vtype=gp.GRB.CONTINUOUS, name="dogs")
cats = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cats")


# Set objective
m.setObjective(50 * dogs + 40 * cats, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * dogs + 15 * cats <= 1000, "heating")
m.addConstr(30 * dogs + 20 * cats <= 1500, "molding")
m.addConstr(20 * dogs + 15 * cats <= 1200, "cooling")
m.addConstr(dogs >=0)
m.addConstr(cats >=0)


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of dogs to make: {dogs.x}")
    print(f"Number of cats to make: {cats.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

