
from gurobipy import *

# Create a new model
model = Model("Glass_Dogs_and_Cats")

# Add variables to the model
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="glass_dogs", lb=0)
x2 = model.addVar(vtype=GRB.CONTINUOUS, name="glass_cats", lb=0)

# Set the objective function
model.setObjective(50*x1 + 40*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(10*x1 + 15*x2 <= 1000, "heating_constraint")
model.addConstr(30*x1 + 20*x2 <= 1500, "molding_constraint")
model.addConstr(20*x1 + 15*x2 <= 1200, "cooling_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found")
