
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="glass_dogs", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="glass_cats", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(50 * x1 + 40 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(10 * x1 + 15 * x2 <= 1000, name="heating_constraint")
    model.addConstr(30 * x1 + 20 * x2 <= 1500, name="molding_constraint")
    model.addConstr(20 * x1 + 15 * x2 <= 1200, name="cooling_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: glass dogs = {x1.varValue}, glass cats = {x2.varValue}")
        print(f"Max profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found")

solve_optimization_problem()
