
import gurobipy as gp

# Create a new model
m = gp.Model("Peter's Fertilizer Mix")

# Create variables
green_cycle = m.addVar(lb=0, name="GreenCycle")  # kg of GreenCycle
grow_safe = m.addVar(lb=0, name="GrowSafe")  # kg of GrowSafe


# Set objective function: Minimize cost
m.setObjective(1.5 * green_cycle + 1.8 * grow_safe, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2.1 * green_cycle + 3.5 * grow_safe >= 9, "Nitrous Oxide Requirement")
m.addConstr(1.3 * green_cycle + 1.1 * grow_safe >= 5, "Vitamin Mix Requirement")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Minimum Cost: ${m.objVal:.2f}")
    print(f"GreenCycle: {green_cycle.x:.2f} kg")
    print(f"GrowSafe: {grow_safe.x:.2f} kg")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

