
from gurobipy import *

# Create a new model
m = Model("Peter'sCompound")

# Create variables
x1 = m.addVar(lb=0, name="GreenCycle")
x2 = m.addVar(lb=0, name="GrowSafe")

# Set the objective function
m.setObjective(1.5*x1 + 1.8*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2.1*x1 + 3.5*x2 >= 9, "NitrousOxideConstraint")
m.addConstr(1.3*x1 + 1.1*x2 >= 5, "VitaminMixConstraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"GreenCycle: {x1.x}")
    print(f"GrowSafe: {x2.x}")
    print(f"Total Cost: {m.objVal}")
else:
    print("No optimal solution found")
