
import gurobipy as gp

# Create a new model
model = gp.Model("plant_growth_compound")

# Define the variables
x1 = model.addVar(name="GreenCycle", lb=0)  # GreenCycle
x2 = model.addVar(name="GrowSafe", lb=0)   # GrowSafe

# Define the objective function
model.setObjective(1.5 * x1 + 1.8 * x2, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(2.1 * x1 + 3.5 * x2 >= 9, name="nitrous_oxide")
model.addConstr(1.3 * x1 + 1.1 * x2 >= 5, name="vitamin_mix")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"GreenCycle: {x1.varValue} kg")
    print(f"GrowSafe: {x2.varValue} kg")
    print(f"Minimum cost: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
